#ifndef DAPLICACION_H
    #define DAPLICACION_H

    #include "DError.h"
    #include <vector>
    #include "DString.h"
    #include "DSistema.h"
    #include <TCHAR.h> // Dejar esta cabecera ya que en ciertas ocasiones hay problemas con WinMain y _tWinMain
    #include "DBaseWnd.h"

    namespace DWL {
        // Enumeracin para los posibles estados basicos de la aplicacin
        enum DEnum_EstadoAplicacion {
            DEnum_EstadoAplicacion_Uninicializada,
            DEnum_EstadoAplicacion_Empezando,
            DEnum_EstadoAplicacion_Funcionando,
            DEnum_EstadoAplicacion_Cerrando
        };

        class DTipoBaseWnd {
          public:
                                DTipoBaseWnd(DBaseWnd *nBaseWnd, const DEnum_TipoBaseWnd nTipo, const UINT nID, DBaseWnd *nPadre) : BaseWnd(nBaseWnd), Tipo(nTipo), ID(nID), Padre(nPadre) { };
            DEnum_TipoBaseWnd   Tipo; 
            DBaseWnd           *BaseWnd;
            DBaseWnd           *Padre;
            UINT                ID;
        };

        template <typename TIPO_DEVUELTO> class DEventosPadre;

        // Clase base DAplicacion
        class DAplicacion : public DObjeto {
          public:
                                                    DAplicacion(void);
                                                   ~DAplicacion(void);
            virtual const int                       Evento_Empezar(void)        { return 0; };
            virtual const int                       Evento_BuclePrincipal(void) { int Ret = 0; while (_Terminar == false) { Ret = Eventos_Esperar(); } return Ret; };
            virtual const int                       Evento_Terminar(void)       { return 0; };
            virtual const int                       Evento_TerminarGUI(void)    { _Terminar = true; return 0; };
            inline const DEnum_EstadoAplicacion     Estado(void)                { return _Estado; };
            void                                    Terminar(void)              { _Terminar = true; };
            const int                               Ejecutar(void);
            const int                               Eventos_Esperar(void);
            void                                    Eventos_Mirar(void);
            const TCHAR                            *AppPath(void)               { return _AppPath(); };

            virtual const TCHAR                    *Objeto_Nombre(void)         { return TEXT("DAplicacion"); };
            virtual const DEnum_Objeto              Objeto_ID(void)             { return DEnum_Objeto_Aplicacion; };
        
          protected :
            DString                                _AppPath;
            // Control de ventanas padre
            const DEnum_TipoBaseWnd                _ObtenerTipoBaseWnd(const UINT cID);
            const size_t                           _AgregarBaseWnd(DBaseWnd *nBaseWnd, const DEnum_TipoBaseWnd nTipo, const UINT nID, DBaseWnd *nPadre);
            const size_t                           _EliminarBaseWnd(DBaseWnd *nBaseWnd);
            std::vector<DTipoBaseWnd>              _BaseWnd;

            bool                                   _Terminar;
            DEnum_EstadoAplicacion                 _Estado;

            friend class DBaseWnd;
            friend class DEventosPadre<LRESULT>;
            friend class DEventosPadre<INT_PTR>;
        };

        extern DAplicacion *_APLICACION;
        extern DSistema Sistema;

        // Esta macro se utiliza para definir un acceso global a la clase aplicacion final
        // Ejemplo : #define App DWL_APP(MiClaseAplicacion)
        #define DWL_APP(DAPLICACION) (*static_cast<DAPLICACION *>(_APLICACION)) 

/*        // Funcion plantilla que devuelve la direccin de la clase aplicacin
        template <typename TipoAplicacion> TipoAplicacion &DWLApp(void) {
            return *static_cast<TipoAplicacion *>(_APLICACION);
        }*/


        // Macro que crea la funcin WinMain 
        // Esta macro debe utilizarse el archivo de definiciones (.cpp) de nuestra clase aplicacion.
        #ifdef UNICODE
            // WinMain UNICODE
            #define DWL_INICIAR(DAPLICACION)                                                                                \
                int APIENTRY _tWinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPTSTR lpCmdLine, int nCmdShow) {      \
                    return DWLIniciar<DAPLICACION>();                                                                       \
                };  
        #else 
            // WinMain ANSI
            #define DWL_INICIAR(DAPLICACION)                                                                             \
                int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {      \
                    return DWLIniciar<DAPLICACION>();                                                                    \
                };
        #endif


        // Funcin plantilla que inicia la clase DAplicacion derivada
        template <typename TipoAplicacion> int DWLIniciar(void) {
            #ifdef _DEBUG
                _APLICACION = new TipoAplicacion;
                int Ret = _APLICACION->Ejecutar();
                delete _APLICACION;
                return Ret;
            #else
                TCHAR MensajeError[2048];
                try {
                    _APLICACION = new TipoAplicacion;
                    int Ret = _APLICACION->Ejecutar();
                    delete _APLICACION;
                    return Ret;
                }
                catch (DError &ErrorAplicacion) {
                    wsprintf(MensajeError, TEXT("%s\n%s"), ErrorAplicacion.FuncionError(), ErrorAplicacion.MensajeError());
    //                wsprintf(MensajeError, TEXT("%s\n%s"), ErrorAplicacion.Objeto()->Objeto_Nombre(), ErrorAplicacion.MensajeError());
                    MessageBox(NULL, MensajeError, TEXT("Error"), MB_ICONEXCLAMATION);
                    // Si hay un error en GetLastError lo mostrara (parece que no....)
    //                DDebug::MostrarUltimoError(TEXT("GetLastError en formato texto :\n"), MensajeError);
                    return -1;
                }
                catch (...) {
                    return -1;
                }
            #endif
        }

    };

#endif